/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionGlobalScopedRecursionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testRecursion() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Throwable.class).to("mock:c")).log("onException")).throwException((Exception)new NullPointerException("A NPE error here"))).end();
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:test").to("mock:a")).log("test")).throwException((Exception)new IllegalStateException("Bad state"))).to("log:test")).to("mock:b");
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:test", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            NullPointerException npe = OnExceptionGlobalScopedRecursionTest.assertIsInstanceOf(NullPointerException.class, e.getCause());
            Assertions.assertEquals((Object)"A NPE error here", (Object)npe.getMessage());
            IllegalStateException ise = OnExceptionGlobalScopedRecursionTest.assertIsInstanceOf(IllegalStateException.class, npe.getSuppressed()[0]);
            Assertions.assertEquals((Object)"Bad state", (Object)ise.getMessage());
        }
    }

    @Test
    public void testRecursionHandled() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Throwable.class).handled(true).to("mock:c")).log("onException")).throwException((Exception)new NullPointerException("A NPE error here"))).end();
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:test").to("mock:a")).log("test")).throwException((Exception)new IllegalStateException("Bad state"))).to("log:test")).to("mock:b");
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:test", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            NullPointerException npe = OnExceptionGlobalScopedRecursionTest.assertIsInstanceOf(NullPointerException.class, e.getCause());
            Assertions.assertEquals((Object)"A NPE error here", (Object)npe.getMessage());
            IllegalStateException ise = OnExceptionGlobalScopedRecursionTest.assertIsInstanceOf(IllegalStateException.class, npe.getSuppressed()[0]);
            Assertions.assertEquals((Object)"Bad state", (Object)ise.getMessage());
        }
    }

    @Test
    public void testRecursionDirectNoErrorHandler() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.getMockEndpoint("mock:d").expectedMessageCount(1);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Throwable.class).to("mock:c")).log("onException")).to("direct:error")).end();
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:test").to("mock:a")).log("test")).throwException((Exception)new IllegalStateException("Bad state"))).to("log:test")).to("mock:b");
                ((RouteDefinition)((RouteDefinition)this.from("direct:error").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:d")).log("error")).throwException((Exception)new NullPointerException("A NPE error here"));
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:test", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            NullPointerException npe = OnExceptionGlobalScopedRecursionTest.assertIsInstanceOf(NullPointerException.class, e.getCause());
            Assertions.assertEquals((Object)"A NPE error here", (Object)npe.getMessage());
            IllegalStateException ise = OnExceptionGlobalScopedRecursionTest.assertIsInstanceOf(IllegalStateException.class, npe.getSuppressed()[0]);
            Assertions.assertEquals((Object)"Bad state", (Object)ise.getMessage());
        }
    }

    @Test
    public void testRecursionHandledDirectNoErrorHandler() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.getMockEndpoint("mock:d").expectedMessageCount(1);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Throwable.class).handled(true).to("mock:c")).log("onException")).to("direct:error")).end();
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:test").to("mock:a")).log("test")).throwException((Exception)new IllegalStateException("Bad state"))).to("log:test")).to("mock:b");
                ((RouteDefinition)((RouteDefinition)this.from("direct:error").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:d")).log("error")).throwException((Exception)new NullPointerException("A NPE error here"));
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:test", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            NullPointerException npe = OnExceptionGlobalScopedRecursionTest.assertIsInstanceOf(NullPointerException.class, e.getCause());
            Assertions.assertEquals((Object)"A NPE error here", (Object)npe.getMessage());
            IllegalStateException ise = OnExceptionGlobalScopedRecursionTest.assertIsInstanceOf(IllegalStateException.class, npe.getSuppressed()[0]);
            Assertions.assertEquals((Object)"Bad state", (Object)ise.getMessage());
        }
    }

    @Test
    public void testRecursionDirect() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.getMockEndpoint("mock:d").expectedMessageCount(1);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Throwable.class).to("mock:c")).log("onException")).to("direct:error")).end();
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:test").to("mock:a")).log("test")).throwException((Exception)new IllegalStateException("Bad state"))).to("log:test")).to("mock:b");
                ((RouteDefinition)((RouteDefinition)this.from("direct:error").to("mock:d")).log("error")).throwException((Exception)new NullPointerException("A NPE error here"));
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:test", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            NullPointerException npe = OnExceptionGlobalScopedRecursionTest.assertIsInstanceOf(NullPointerException.class, e.getCause());
            Assertions.assertEquals((Object)"A NPE error here", (Object)npe.getMessage());
        }
    }

    @Test
    public void testRecursionHandledDirect() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.getMockEndpoint("mock:d").expectedMessageCount(1);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Throwable.class).handled(true).to("mock:c")).log("onException")).to("direct:error")).end();
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:test").to("mock:a")).log("test")).throwException((Exception)new IllegalStateException("Bad state"))).to("log:test")).to("mock:b");
                ((RouteDefinition)((RouteDefinition)this.from("direct:error").to("mock:d")).log("error")).throwException((Exception)new NullPointerException("A NPE error here"));
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:test", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            NullPointerException npe = OnExceptionGlobalScopedRecursionTest.assertIsInstanceOf(NullPointerException.class, e.getCause());
            Assertions.assertEquals((Object)"A NPE error here", (Object)npe.getMessage());
        }
    }
}

