/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class OnExceptionGlobalAndDLCErrorHandlerIssueTest
extends ContextTestSupport {
    @Test
    public void testNoOnGlobalException() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:global").expectedMessageCount(1);
        this.getMockEndpoint("mock:local").expectedMessageCount(0);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnRouteException() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:global").expectedMessageCount(0);
        this.getMockEndpoint("mock:local").expectedMessageCount(1);
        this.template.sendBody("direct:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                this.onException(Exception.class).handled(true).to("mock:global");
                ((OnExceptionDefinition)this.from("direct:bar").routeId("bar").onException(IllegalArgumentException.class).handled(true).to("mock:local")).end().to("mock:bar").throwException((Exception)new IllegalArgumentException("Damn"));
                ((RouteDefinition)this.from("direct:foo").routeId("foo").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

