/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.apache.camel.processor.onexception.MyServiceBean;
import org.apache.camel.processor.onexception.MyTechnicalException;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OnExceptionFromChoiceTest
extends ContextTestSupport {
    private MyServiceBean myServiceBean;

    @Test
    public void testNoErrorWhen() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:func").expectedMessageCount(0);
        this.getMockEndpoint("mock:tech").expectedMessageCount(0);
        this.getMockEndpoint("mock:otherwise").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:when");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>James</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFunctionalError() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:tech").expectedMessageCount(0);
        this.getMockEndpoint("mock:when").expectedMessageCount(0);
        this.getMockEndpoint("mock:otherwise").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:func");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>Func</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTechnicalError() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:func").expectedMessageCount(0);
        this.getMockEndpoint("mock:when").expectedMessageCount(0);
        this.getMockEndpoint("mock:otherwise").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:tech");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>Tech</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.myServiceBean = new MyServiceBean();
        super.setUp();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myServiceBean", (Object)this.myServiceBean);
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                OnExceptionFromChoiceTest.this.context.setTracing(Boolean.valueOf(true));
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error"));
                this.onException(MyTechnicalException.class).maximumRedeliveries(0).handled(true).to("mock:tech");
                this.onException(MyFunctionalException.class).maximumRedeliveries(0).handled(true).to("mock:func");
                ((ChoiceDefinition)this.from("direct:start").choice().when(this.method("myServiceBean").isEqualTo((Object)"James")).to("mock:when")).otherwise().to("mock:otherwise");
            }
        };
    }
}

