/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.onexception.OnExceptionContinueTwoTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionContinueTwoPredicateTest
extends OnExceptionContinueTwoTest {
    private final AtomicInteger predicateInvoked = new AtomicInteger();
    private final AtomicInteger processorInvoked = new AtomicInteger();

    @Override
    @Test
    public void testContinuedTwo() throws Exception {
        this.getMockEndpoint("mock:me").expectedMessageCount(2);
        super.testContinuedTwo();
        Assertions.assertEquals((int)2, (int)this.predicateInvoked.get());
        Assertions.assertEquals((int)2, (int)this.processorInvoked.get());
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Predicate predicate = new Predicate(){

                    public boolean matches(Exchange exchange) {
                        OnExceptionContinueTwoPredicateTest.this.predicateInvoked.incrementAndGet();
                        return true;
                    }
                };
                ((OnExceptionDefinition)this.onException(IllegalArgumentException.class).continued(predicate).process(new Processor(){

                    public void process(Exchange exchange) {
                        OnExceptionContinueTwoPredicateTest.this.processorInvoked.incrementAndGet();
                    }
                })).to("mock:me");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:start")).throwException((Exception)new IllegalArgumentException("Forced"))).to("mock:middle")).throwException((Exception)new IllegalArgumentException("Forced Again"))).to("mock:result");
            }
        };
    }
}

