/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.onexception.OnExceptionContinueTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionContinuePredicateTest
extends OnExceptionContinueTest {
    private final AtomicInteger predicateInvoked = new AtomicInteger();
    private final AtomicInteger processorInvoked = new AtomicInteger();

    @Override
    @Test
    public void testContinued() throws Exception {
        this.getMockEndpoint("mock:me").expectedMessageCount(1);
        super.testContinued();
        Assertions.assertEquals((int)1, (int)this.predicateInvoked.get());
        Assertions.assertEquals((int)1, (int)this.processorInvoked.get());
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Predicate predicate = new Predicate(){

                    public boolean matches(Exchange exchange) {
                        OnExceptionContinuePredicateTest.this.predicateInvoked.incrementAndGet();
                        return true;
                    }
                };
                ((OnExceptionDefinition)this.onException(IllegalArgumentException.class).continued(predicate).process(new Processor(){

                    public void process(Exchange exchange) {
                        OnExceptionContinuePredicateTest.this.processorInvoked.incrementAndGet();
                    }
                })).to("mock:me");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:start")).throwException((Exception)new IllegalArgumentException("Forced"))).to("mock:result");
            }
        };
    }
}

