/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import java.io.IOException;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.apache.camel.processor.onexception.MyTechnicalException;
import org.apache.camel.processor.onexception.OnExceptionComplexRouteTest;
import org.junit.jupiter.api.Test;

public class OnExceptionComplexWithNestedErrorHandlerRouteTest
extends OnExceptionComplexRouteTest {
    @Test
    public void testNoError3() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start3", (Object)"<order><type>myType</type><user>James</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFunctionalError3() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:error3").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start3", (Object)"<order><type>myType</type><user>Func</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").redeliveryDelay(0L).logStackTrace(false));
                this.onException(MyTechnicalException.class).handled(true).maximumRedeliveries(2).to("mock:tech.error");
                this.from("direct:start").onException(MyFunctionalException.class).maximumRedeliveries(0).end().to("bean:myServiceBean").to("mock:result");
                ((OnExceptionDefinition)this.from("direct:start2").onException(MyFunctionalException.class).handled(true).maximumRedeliveries(0).to("mock:handled")).end().to("bean:myServiceBean").to("mock:result");
                this.from("direct:start3").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error3").maximumRedeliveries(0)).onException(MyFunctionalException.class).handled(true).end().onException(IOException.class).maximumRedeliveries(3).end().to("bean:myServiceBean").to("mock:result");
            }
        };
    }
}

