/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.apache.camel.processor.onexception.MyServiceBean;
import org.apache.camel.processor.onexception.MyTechnicalException;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OnExceptionComplexRouteTest
extends ContextTestSupport {
    protected MyServiceBean myServiceBean;

    @Test
    public void testNoError() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>James</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNoError2() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start2", (Object)"<order><type>myType</type><user>James</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFunctionalError() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>Func</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFunctionalError2() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start2", (Object)"<order><type>myType</type><user>Func</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTechnicalError() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:tech.error").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>Tech</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTechnicalError2() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:tech.error").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start2", (Object)"<order><type>myType</type><user>Tech</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.myServiceBean = new MyServiceBean();
        super.setUp();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myServiceBean", (Object)this.myServiceBean);
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").redeliveryDelay(0L).logStackTrace(false));
                this.onException(MyTechnicalException.class).handled(true).maximumRedeliveries(2).to("mock:tech.error");
                this.from("direct:start").onException(MyFunctionalException.class).maximumRedeliveries(0).end().to("bean:myServiceBean").to("mock:result");
                ((OnExceptionDefinition)this.from("direct:start2").onException(MyFunctionalException.class).handled(true).maximumRedeliveries(0).to("mock:handled")).end().to("bean:myServiceBean").to("mock:result");
            }
        };
    }
}

