/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ErrorHandlerSuppressExceptionTest
extends ContextTestSupport {
    @Test
    public void testSuppressException() {
        Exchange out = this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        Assertions.assertTrue((boolean)out.isFailed());
        Exception t = out.getException();
        Assertions.assertNotNull((Object)t);
        Assertions.assertEquals((Object)"Forced error during handling", (Object)t.getMessage());
        Assertions.assertEquals((int)1, (int)t.getSuppressed().length);
        Assertions.assertEquals((Object)"Root exception", (Object)t.getSuppressed()[0].getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).maximumRedeliveries(3).redeliveryDelay(0L).process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new IllegalArgumentException("Forced error during handling");
                    }
                });
                this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IOException("Root exception");
                    }
                });
            }
        };
    }
}

