/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.junit.jupiter.api.Test;

public class DoCatchDirectDynamicRouteTest
extends ContextTestSupport {
    private int counter;

    @Test
    public void testDoCatchDirectRoute() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("direct:a")).doCatch(Exception.class).to("direct:c")).end();
                ((RouteDefinition)this.from("direct:a").to("mock:a")).dynamicRouter((Expression)this.method(DoCatchDirectDynamicRouteTest.class, "next"));
                ((RouteDefinition)this.from("direct:b").to("mock:b")).throwException((Exception)new IllegalArgumentException("Forced"));
                this.from("direct:c").to("mock:c");
            }
        };
    }

    public String next() {
        if (this.counter++ == 0) {
            return "direct:b";
        }
        return null;
    }
}

