/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultErrorHandlerRetryWhileTest
extends ContextTestSupport {
    private static int invoked;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myRetryHandler", (Object)new MyRetryBean());
        return jndi;
    }

    @Test
    public void testRetryUntil() {
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        Assertions.assertEquals((int)3, (int)invoked);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().redeliveryDelay(0L).retryWhile((Expression)this.method("myRetryHandler")));
                this.from("direct:start").process((Processor)new MyProcessor());
            }
        };
    }

    public static class MyRetryBean {
        public boolean retry() {
            ++invoked;
            return true;
        }
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            if (invoked < 3) {
                throw new MyFunctionalException("Sorry you cannot do this");
            }
            exchange.getIn().setBody((Object)"Bye World");
        }
    }
}

