/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultErrorHandlerExchangeFormatterRefTest
extends ContextTestSupport {
    private static int invoked;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myExchangeFormatter", (Object)new MyExchangeFormatter());
        return jndi;
    }

    @Test
    public void testRetryUntil() {
        try {
            this.template.requestBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Expected the exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)invoked);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().exchangeFormatterRef("myExchangeFormatter"));
                this.from("direct:start").process((Processor)new MyProcessor());
            }
        };
    }

    public static class MyExchangeFormatter
    implements ExchangeFormatter {
        public String format(Exchange exchange) {
            ++invoked;
            return "Exchange";
        }
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            throw new MyFunctionalException("Sorry you cannot do this");
        }
    }
}

