/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContextScopedOnExceptionLoadBalancerStopRouteTest
extends ContextTestSupport {
    @Test
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:exception").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testError() throws Exception {
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:exception").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testErrorOk() throws Exception {
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Kaboom", "World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:exception").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testErrorOkError() throws Exception {
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Kaboom", "World", "Kaboom"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:exception").expectedBodiesReceived(new Object[]{"Kaboom", "Kaboom"});
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.template.sendBody("direct:start", (Object)"World");
        Awaitility.await().atMost(3L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteController().getRouteStatus("errorRoute")));
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
        SedaEndpoint seda = this.getMandatoryEndpoint("seda:error", SedaEndpoint.class);
        SedaEndpoint seda2 = this.getMandatoryEndpoint("seda:error2", SedaEndpoint.class);
        int size = seda.getQueue().size();
        int size2 = seda2.getQueue().size();
        Assertions.assertTrue((size == 1 || size2 == 1 ? 1 : 0) != 0, (String)"There should be 1 exchange on the seda or seda2 queue");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((LoadBalanceDefinition)this.onException(Exception.class).handled(true).loadBalance().roundRobin().to(new String[]{"seda:error", "seda:error2"})).end().to("mock:exception");
                ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from("direct:start").to("mock:start")).choice().when(this.body().contains((Object)"Kaboom")).throwException((Exception)new IllegalArgumentException("Forced"))).otherwise().transform((Expression)this.body().prepend((Object)"Bye "))).to("mock:result");
                ((RouteDefinition)this.from("seda:error").routeId("errorRoute").to("controlbus:route?action=stop&routeId=errorRoute&async=true")).to("mock:error");
            }
        };
    }
}

