/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.io.ByteArrayInputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.StreamCache;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NoStreamCachingTest
extends ContextTestSupport {
    private static final String MESSAGE = "<hello>world!</hello>";
    private MockEndpoint a;
    private MockEndpoint b;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.a = this.getMockEndpoint("mock:a");
        this.b = this.getMockEndpoint("mock:b");
    }

    @Test
    public void testNoStreamCache() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:a").noStreamCaching().to("mock:a");
            }
        });
        this.context.start();
        this.a.expectedMessageCount(1);
        ByteArrayInputStream message = new ByteArrayInputStream(MESSAGE.getBytes());
        this.template.sendBody("direct:a", (Object)message);
        this.assertMockEndpointsSatisfied();
        boolean b1 = this.a.assertExchangeReceived(0).getIn().getBody() instanceof ByteArrayInputStream;
        Assertions.assertTrue((boolean)b1);
        Assertions.assertEquals((Object)MESSAGE, (Object)this.a.assertExchangeReceived(0).getIn().getBody(String.class));
    }

    @Test
    public void testStreamCacheIsDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:a").to("mock:a");
            }
        });
        this.context.start();
        this.a.expectedMessageCount(1);
        ByteArrayInputStream message = new ByteArrayInputStream(MESSAGE.getBytes());
        this.template.sendBody("direct:a", (Object)message);
        this.assertMockEndpointsSatisfied();
        boolean a1 = this.a.assertExchangeReceived(0).getIn().getBody() instanceof StreamCache;
        Assertions.assertTrue((boolean)a1);
        Assertions.assertEquals((Object)MESSAGE, (Object)this.a.assertExchangeReceived(0).getIn().getBody(String.class));
    }

    @Test
    public void testMixed() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:a").noStreamCaching().to("mock:a");
                this.from("direct:b").streamCaching().to("mock:b");
            }
        });
        this.context.start();
        this.a.expectedMessageCount(1);
        this.b.expectedMessageCount(1);
        ByteArrayInputStream message = new ByteArrayInputStream(MESSAGE.getBytes());
        this.template.sendBody("direct:a", (Object)message);
        ByteArrayInputStream message2 = new ByteArrayInputStream(MESSAGE.getBytes());
        this.template.sendBody("direct:b", (Object)message2);
        this.assertMockEndpointsSatisfied();
        boolean b2 = this.a.assertExchangeReceived(0).getIn().getBody() instanceof ByteArrayInputStream;
        Assertions.assertTrue((boolean)b2);
        Assertions.assertEquals((Object)MESSAGE, (Object)this.a.assertExchangeReceived(0).getIn().getBody(String.class));
        boolean b1 = this.b.assertExchangeReceived(0).getIn().getBody() instanceof StreamCache;
        Assertions.assertTrue((boolean)b1);
        Assertions.assertEquals((Object)MESSAGE, (Object)this.b.assertExchangeReceived(0).getIn().getBody(String.class));
    }
}

