/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Ordered;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.InterceptStrategy;
import org.junit.jupiter.api.Test;

public class InterceptorStrategyOrderedTest
extends ContextTestSupport {
    @Test
    public void testInterceptorStrategyOrdered() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("order", (Object)"12");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                InterceptorStrategyOrderedTest.this.context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)new BarInterceptStrategy());
                InterceptorStrategyOrderedTest.this.context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)new FooInterceptStrategy());
                this.from("direct:start").to("mock:result");
            }
        };
    }

    public static class BarInterceptStrategy
    implements InterceptStrategy,
    Ordered {
        public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, final Processor target, Processor nextTarget) {
            Processor answer = new Processor(){

                public void process(Exchange exchange) throws Exception {
                    Object order = (String)exchange.getIn().getHeader("order", (Object)"", String.class);
                    order = (String)order + this.getOrder();
                    exchange.getIn().setHeader("order", order);
                    target.process(exchange);
                }
            };
            return answer;
        }

        public int getOrder() {
            return 2;
        }
    }

    public static class FooInterceptStrategy
    implements InterceptStrategy,
    Ordered {
        public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, final Processor target, Processor nextTarget) {
            Processor answer = new Processor(){

                public void process(Exchange exchange) throws Exception {
                    Object order = (String)exchange.getIn().getHeader("order", (Object)"", String.class);
                    order = (String)order + this.getOrder();
                    exchange.getIn().setHeader("order", order);
                    target.process(exchange);
                }
            };
            return answer;
        }

        public int getOrder() {
            return 1;
        }
    }
}

