/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.InterceptStrategy;
import org.junit.jupiter.api.Test;

public class InterceptorStrategyNotOrderedTest
extends ContextTestSupport {
    @Test
    public void testInterceptorStrategyNotOrdered() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("order", (Object)"foobar");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                InterceptorStrategyNotOrderedTest.this.context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)new FooInterceptStrategy());
                InterceptorStrategyNotOrderedTest.this.context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)new BarInterceptStrategy());
                this.from("direct:start").to("mock:result");
            }
        };
    }

    private static class BarInterceptStrategy
    implements InterceptStrategy {
        private BarInterceptStrategy() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, final Processor target, Processor nextTarget) {
            Processor answer = new Processor(){

                public void process(Exchange exchange) throws Exception {
                    Object order = (String)exchange.getIn().getHeader("order", (Object)"", String.class);
                    order = (String)order + "bar";
                    exchange.getIn().setHeader("order", order);
                    target.process(exchange);
                }
            };
            return answer;
        }
    }

    private static class FooInterceptStrategy
    implements InterceptStrategy {
        private FooInterceptStrategy() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, final Processor target, Processor nextTarget) {
            Processor answer = new Processor(){

                public void process(Exchange exchange) throws Exception {
                    Object order = (String)exchange.getIn().getHeader("order", (Object)"", String.class);
                    order = (String)order + "foo";
                    exchange.getIn().setHeader("order", order);
                    target.process(exchange);
                }
            };
            return answer;
        }
    }
}

