/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.processor.interceptor.ConditionSupport;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.Condition;
import org.apache.camel.spi.Debugger;
import org.apache.camel.support.BreakpointSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DebugTest
extends ContextTestSupport {
    private final List<String> logs = new ArrayList<String>();
    private Condition camelCondition;
    private Condition mockCondition;
    private Condition doneCondition;
    private Breakpoint breakpoint;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.breakpoint = new BreakpointSupport(){

            public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
                String body = (String)exchange.getIn().getBody(String.class);
                DebugTest.this.logs.add("Breakpoint at " + String.valueOf(definition) + " with body: " + body);
            }

            public void onEvent(Exchange exchange, CamelEvent.ExchangeEvent event, NamedNode definition) {
                String body = (String)exchange.getIn().getBody(String.class);
                DebugTest.this.logs.add("Breakpoint event " + event.getClass().getSimpleName() + " with body: " + body);
            }
        };
        this.camelCondition = new ConditionSupport(){

            @Override
            public boolean matchProcess(Exchange exchange, Processor processor, NamedNode definition, boolean before) {
                return TestSupport.body().contains((Object)"Camel").matches(exchange);
            }
        };
        this.mockCondition = new ConditionSupport(){

            @Override
            public boolean matchProcess(Exchange exchange, Processor processor, NamedNode definition, boolean before) {
                if (definition instanceof ToDefinition) {
                    ToDefinition to = (ToDefinition)definition;
                    return to.getUri().startsWith("mock");
                }
                return false;
            }
        };
        this.doneCondition = new ConditionSupport(){

            @Override
            public boolean matchEvent(Exchange exchange, CamelEvent.ExchangeEvent event) {
                return event.getType() == CamelEvent.Type.ExchangeCompleted;
            }
        };
    }

    @Test
    public void testDebug() throws Exception {
        this.context.getDebugger().addBreakpoint(this.breakpoint, new Condition[]{this.camelCondition});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.logs.size());
        Assertions.assertEquals((Object)"Breakpoint at To[log:foo] with body: Hello Camel", (Object)this.logs.get(0));
        Assertions.assertEquals((Object)"Breakpoint at To[mock:result] with body: Hello Camel", (Object)this.logs.get(1));
    }

    @Test
    public void testDebugEvent() throws Exception {
        this.context.getDebugger().addBreakpoint(this.breakpoint, new Condition[]{this.doneCondition});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.logs.size());
        Assertions.assertEquals((Object)"Breakpoint event ExchangeCompletedEvent with body: Hello World", (Object)this.logs.get(0));
        Assertions.assertEquals((Object)"Breakpoint event ExchangeCompletedEvent with body: Hello Camel", (Object)this.logs.get(1));
    }

    @Test
    public void testDebugSuspended() throws Exception {
        this.context.getDebugger().addBreakpoint(this.breakpoint, new Condition[]{this.mockCondition, this.camelCondition});
        this.context.getDebugger().suspendAllBreakpoints();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)0, (int)this.logs.size());
        this.context.getDebugger().activateAllBreakpoints();
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.logs.size());
        Assertions.assertEquals((Object)"Breakpoint at To[mock:result] with body: Hello Camel", (Object)this.logs.get(0));
    }

    @Test
    public void testDebugRemoveBreakpoint() throws Exception {
        this.context.getDebugger().addBreakpoint(this.breakpoint);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)10, (int)this.logs.size());
        this.context.getDebugger().removeBreakpoint(this.breakpoint);
        this.resetMocks();
        this.logs.clear();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)0, (int)this.logs.size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                DebugTest.this.context.setDebugging(Boolean.valueOf(true));
                DebugTest.this.context.setDebugger((Debugger)new DefaultDebugger());
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

