/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Debugger;
import org.apache.camel.support.BreakpointSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DebugSingleStepTest
extends ContextTestSupport {
    private final List<String> logs = new ArrayList<String>();
    private Breakpoint breakpoint;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.breakpoint = new BreakpointSupport(){

            public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
                String body = (String)exchange.getIn().getBody(String.class);
                DebugSingleStepTest.this.logs.add("Single stepping at " + definition.getLabel() + " with body: " + body);
            }
        };
    }

    @Test
    public void testDebug() throws Exception {
        this.context.getDebugger().addSingleStepBreakpoint(this.breakpoint);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)6, (int)this.logs.size());
        Assertions.assertEquals((Object)"Single stepping at log:foo with body: Hello World", (Object)this.logs.get(0));
        Assertions.assertEquals((Object)"Single stepping at log:bar with body: Hello World", (Object)this.logs.get(1));
        Assertions.assertEquals((Object)"Single stepping at mock:result with body: Hello World", (Object)this.logs.get(2));
        Assertions.assertEquals((Object)"Single stepping at log:foo with body: Hello Camel", (Object)this.logs.get(3));
        Assertions.assertEquals((Object)"Single stepping at log:bar with body: Hello Camel", (Object)this.logs.get(4));
        Assertions.assertEquals((Object)"Single stepping at mock:result with body: Hello Camel", (Object)this.logs.get(5));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                DebugSingleStepTest.this.context.setDebugging(Boolean.valueOf(true));
                DebugSingleStepTest.this.context.setDebugger((Debugger)new DefaultDebugger());
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).to("log:bar")).to("mock:result");
            }
        };
    }
}

