/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.ConditionSupport;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Condition;
import org.apache.camel.spi.Debugger;
import org.apache.camel.support.BreakpointSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DebugSingleStepConditionTest
extends ContextTestSupport {
    private final List<String> logs = new ArrayList<String>();
    private Breakpoint breakpoint;
    private Condition beerCondition;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.breakpoint = new BreakpointSupport(){

            public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
                String body = (String)exchange.getIn().getBody(String.class);
                DebugSingleStepConditionTest.this.logs.add("Single stepping at " + definition.getLabel() + " with body: " + body);
            }
        };
        this.beerCondition = new ConditionSupport(){

            @Override
            public boolean matchProcess(Exchange exchange, Processor processor, NamedNode definition, boolean before) {
                return "beer".equals(exchange.getFromRouteId());
            }
        };
    }

    @Test
    public void testDebug() throws Exception {
        this.context.getDebugger().addSingleStepBreakpoint(this.breakpoint, new Condition[]{this.beerCondition});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Carlsberg"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:beer", (Object)"Carlsberg");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.logs.size());
        Assertions.assertEquals((Object)"Single stepping at log:beer with body: Carlsberg", (Object)this.logs.get(0));
        Assertions.assertEquals((Object)"Single stepping at mock:result with body: Carlsberg", (Object)this.logs.get(1));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                DebugSingleStepConditionTest.this.context.setDebugging(Boolean.valueOf(true));
                DebugSingleStepConditionTest.this.context.setDebugger((Debugger)new DefaultDebugger());
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).to("log:bar")).to("mock:result");
                ((RouteDefinition)this.from("direct:beer").routeId("beer").to("log:beer")).to("mock:result");
            }
        };
    }
}

