/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.ConditionSupport;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.Condition;
import org.apache.camel.spi.Debugger;
import org.apache.camel.support.BreakpointSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DebugExceptionEventBreakpointTest
extends ContextTestSupport {
    private final List<String> logs = new ArrayList<String>();
    private Condition exceptionCondition;
    private Breakpoint breakpoint;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.breakpoint = new BreakpointSupport(){

            public void onEvent(Exchange exchange, CamelEvent.ExchangeEvent event, NamedNode definition) {
                Exception e = event.getExchange().getException();
                DebugExceptionEventBreakpointTest.this.logs.add("Breakpoint at " + String.valueOf(definition) + " caused by: " + e.getClass().getSimpleName() + "[" + e.getMessage() + "]");
            }
        };
        this.exceptionCondition = new ConditionSupport(){

            @Override
            public boolean matchEvent(Exchange exchange, CamelEvent.ExchangeEvent event) {
                return event.getType() == CamelEvent.Type.ExchangeFailed;
            }
        };
    }

    @Test
    public void testDebug() throws Exception {
        this.context.getDebugger().addBreakpoint(this.breakpoint, new Condition[]{this.exceptionCondition});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        try {
            this.template.sendBody("direct:start", (Object)"Hello Camel");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.logs.size());
        Assertions.assertEquals((Object)"Breakpoint at ThrowException[java.lang.IllegalArgumentException] caused by: IllegalArgumentException[Damn]", (Object)this.logs.get(0));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                DebugExceptionEventBreakpointTest.this.context.setDebugging(Boolean.valueOf(true));
                DebugExceptionEventBreakpointTest.this.context.setDebugger((Debugger)new DefaultDebugger());
                ((ChoiceDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).choice().when(this.body().contains((Object)"Camel")).throwException((Exception)new IllegalArgumentException("Damn"))).end().to("mock:result");
            }
        };
    }
}

