/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomInterceptorRouteWithChildOutputTest
extends ContextTestSupport {
    private final MyInterceptor myInterceptor = new MyInterceptor();

    @Test
    public void testCustomInterceptor() throws Exception {
        this.getMockEndpoint("mock:child").expectedMessageCount(3);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)this.myInterceptor.getDefs().size());
        CustomInterceptorRouteWithChildOutputTest.assertIsInstanceOf(LogDefinition.class, this.myInterceptor.getDefs().get(0));
        CustomInterceptorRouteWithChildOutputTest.assertIsInstanceOf(ToDefinition.class, this.myInterceptor.getDefs().get(1));
        Assertions.assertEquals((Object)"mock:child", (Object)this.myInterceptor.getDefs().get(1).getLabel());
        CustomInterceptorRouteWithChildOutputTest.assertIsInstanceOf(SplitDefinition.class, this.myInterceptor.getDefs().get(2));
        CustomInterceptorRouteWithChildOutputTest.assertIsInstanceOf(ToDefinition.class, this.myInterceptor.getDefs().get(3));
        Assertions.assertEquals((Object)"mock:result", (Object)this.myInterceptor.getDefs().get(3).getLabel());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                CustomInterceptorRouteWithChildOutputTest.this.context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)CustomInterceptorRouteWithChildOutputTest.this.myInterceptor);
                ((ExpressionNode)((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize(",")).log("Spltted ${body}")).to("mock:child")).end().to("mock:result");
            }
        };
    }

    private static class MyInterceptor
    implements InterceptStrategy {
        private final List<ProcessorDefinition> defs = new ArrayList<ProcessorDefinition>();

        private MyInterceptor() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, Processor target, Processor nextTarget) {
            this.defs.add((ProcessorDefinition)definition);
            return target;
        }

        public List<ProcessorDefinition> getDefs() {
            return this.defs;
        }
    }
}

