/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class AdviceWithTwoRoutesTest
extends ContextTestSupport {
    @Test
    public void testAdviceWithA() throws Exception {
        RouteDefinition route = this.context.getRouteDefinition("a");
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock://a").skipSendToOriginalEndpoint().to("mock:detour");
            }
        });
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:detour").expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdviceWithB() throws Exception {
        RouteDefinition route = this.context.getRouteDefinition("b");
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock://b").skipSendToOriginalEndpoint().to("mock:detour");
            }
        });
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:detour").expectedMessageCount(1);
        this.template.sendBody("direct:b", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdviceWithAB() throws Exception {
        RouteDefinition route = this.context.getRouteDefinition("a");
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock://a").skipSendToOriginalEndpoint().to("mock:detour");
            }
        });
        route = this.context.getRouteDefinition("b");
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock://b").skipSendToOriginalEndpoint().to("mock:detour");
            }
        });
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:detour").expectedMessageCount(2);
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.template.sendBody("direct:b", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:a").routeId("a").to("log:a")).setBody((Expression)this.body().regexReplaceAll("\n", ""))).to("mock:a");
                ((RouteDefinition)this.from("direct:b").routeId("b").to("log:b")).to("mock:b");
            }
        };
    }
}

