/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdviceWithTest
extends ContextTestSupport {
    @Test
    public void testNoAdvised() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdvised() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().to("log:foo")).to("mock:advised");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:advised").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdvisedNoNewRoutesAllowed() throws Exception {
        try {
            AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:bar").to("mock:bar");
                    ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().to("log:foo")).to("mock:advised");
                }
            });
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAdvisedThrowException() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").to("mock:advised")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:advised").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            AdviceWithTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertEquals((Object)"Damn", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdvisedEmptyRoutes() throws Exception {
        try {
            AdviceWith.adviceWith((RouteDefinition)new RouteDefinition(), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() throws Exception {
                    ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().to("log:foo")).to("mock:advised");
                }
            });
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:result");
            }
        };
    }
}

