/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdviceWithTasksSelectTest
extends ContextTestSupport {
    @Test
    public void testSelectFirst() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectFirst().replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSelectLast() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectLast().replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSelectIndexZero() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectIndex(0).replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSelectIndexOne() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectIndex(1).replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSelectIndexTwo() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectIndex(2).replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSelectIndexOutOfBounds() throws Exception {
        try {
            AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() throws Exception {
                    ((MulticastDefinition)this.weaveById("gold*").selectIndex(3).replace().multicast().to("mock:a")).to("mock:b");
                }
            });
            Assertions.fail((String)"Should hve thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("There are no outputs which matches: gold* in the route"), (String)e.getMessage());
        }
    }

    @Test
    public void testSelectRangeZeroOne() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectRange(0, 1).replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.getMockEndpoint("mock:a").expectedMessageCount(2);
        this.getMockEndpoint("mock:b").expectedMessageCount(2);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSelectRangeOneTwo() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectRange(1, 2).replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedMessageCount(2);
        this.getMockEndpoint("mock:b").expectedMessageCount(2);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").log("Got ${body}")).id("foo")).to("mock:foo")).id("gold-1")).to("mock:bar")).id("gold-2")).to("mock:baz")).id("gold-3")).to("mock:result")).id("silver-1");
            }
        };
    }
}

