/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class AdviceWithTasksOnExceptionTest
extends ContextTestSupport {
    @Test
    public void testBeforeWithOnException() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.weaveById("bar").before().to("mock:a").transform((Expression)this.constant("Bye World"));
            }
        });
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.from("direct:start").onException(Exception.class).handled(true).to("mock:error")).end().to("mock:foo").to("mock:bar").id("bar").to("mock:result");
            }
        };
    }
}

