/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.AdviceWithTest;
import org.junit.jupiter.api.Test;

public class AdviceWithRouteIdTest
extends AdviceWithTest {
    @Override
    @Test
    public void testAdvised() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("myRoute"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().to("log:foo")).to("mock:advised");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:advised").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("myRoute").to("mock:foo")).to("mock:result");
                this.from("direct:bar").to("mock:bar");
            }
        };
    }
}

