/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdviceWithReplaceFromTest
extends ContextTestSupport {
    @Test
    public void testReplaceFromUri() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.replaceFromWith("seda:foo");
            }
        });
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testReplaceFromEndpoint() throws Exception {
        final Endpoint endpoint = this.context.getEndpoint("seda:foo");
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.replaceFromWith(endpoint);
            }
        });
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testReplaceFromInvalidUri() throws Exception {
        try {
            AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() throws Exception {
                    this.replaceFromWith("xxx:foo");
                }
            });
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            AdviceWithReplaceFromTest.assertIsInstanceOf(NoSuchEndpointException.class, e.getCause());
        }
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

