/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdviceWithMockEndpointsTest
extends ContextTestSupport {
    @Test
    public void testNoAdvised() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdvisedMockEndpoints() throws Exception {
        AdviceWith.adviceWith((CamelContext)this.context, (Object)"start", a -> a.mockEndpoints());
        this.getMockEndpoint("mock:direct:start").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:direct:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:log:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct:start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct:foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log:foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock:result"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock:direct:start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock:direct:foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock:log:foo"));
    }

    @Test
    public void testAdvisedMockEndpointsWithPattern() throws Exception {
        AdviceWith.adviceWith((CamelContext)this.context, (Object)"start", a -> a.mockEndpoints(new String[]{"log*"}));
        this.getMockEndpoint("mock:log:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct:start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct:foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log:foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock:result"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock:log:foo"));
        Assertions.assertNull((Object)this.context.hasEndpoint("mock:direct:start"));
        Assertions.assertNull((Object)this.context.hasEndpoint("mock:direct:foo"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("start").to("direct:foo")).to("log:foo")).to("mock:result");
                this.from("direct:foo").routeId("foo").transform((Expression)this.constant("Bye World"));
            }
        };
    }
}

