/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdviceWithMockEndpointsHavingParameterTest
extends ContextTestSupport {
    @Test
    public void testNoAdvised() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdvisedMockEndpoints() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(1)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.mockEndpoints();
            }
        });
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:direct:start").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:log:start").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:seda:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)this.context.hasEndpoint("direct:start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("seda:foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log:foo?showHeaders=false"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("log:start?showAll=true"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock:result"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock:direct:start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock:seda:foo"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock:log:start"));
        Assertions.assertNotNull((Object)this.context.hasEndpoint("mock:log:foo"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:foo?size=20").transform((Expression)this.constant("Bye World"))).log("We transformed ${body}")).to("log:foo?showHeaders=false")).to("mock:foo");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("seda:foo")).to("log:start?showAll=true")).to("mock:result");
            }
        };
    }
}

