/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdviceWithLambdaTest
extends ContextTestSupport {
    @Test
    public void testNoAdvised() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdvised() throws Exception {
        AdviceWith.adviceWith((CamelContext)this.context, null, a -> ((InterceptSendToEndpointDefinition)a.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().to("log:foo")).to("mock:advised"));
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:advised").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdvisedSimple() throws Exception {
        AdviceWith.adviceWith((CamelContext)this.context, null, a -> ((InterceptSendToEndpointDefinition)((InterceptSendToEndpointDefinition)a.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().transform((Expression)a.simple("Hello ${body}"))).to("log:foo")).to("mock:advised"));
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:advised").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdvisedNoLog() throws Exception {
        AdviceWith.adviceWith((CamelContext)this.context, null, (boolean)false, a -> {
            a.weaveByToUri("mock:result").remove();
            a.weaveAddLast().transform().constant((Object)"Bye World");
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdvisedNoNewRoutesAllowed() throws Exception {
        try {
            AdviceWith.adviceWith((CamelContext)this.context, (Object)0, a -> {
                a.from("direct:bar").to("mock:bar");
                ((InterceptSendToEndpointDefinition)a.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().to("log:foo")).to("mock:advised");
            });
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAdvisedThrowException() throws Exception {
        AdviceWith.adviceWith((CamelContext)this.context, (Object)"myRoute", a -> ((InterceptSendToEndpointDefinition)a.interceptSendToEndpoint("mock:foo").to("mock:advised")).throwException((Exception)new IllegalArgumentException("Damn")));
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:advised").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            AdviceWithLambdaTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertEquals((Object)"Damn", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdvisedRouteDefinition() throws Exception {
        AdviceWith.adviceWith((CamelContext)this.context, this.context.getRouteDefinitions().get(0), a -> ((InterceptSendToEndpointDefinition)a.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().to("log:foo")).to("mock:advised"));
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:advised").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").id("myRoute")).to("mock:foo")).to("mock:result");
            }
        };
    }
}

