/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdviceWithAutoStartupTest
extends ContextTestSupport {
    @Test
    public void testAdvised() throws Exception {
        Assertions.assertFalse((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
        Assertions.assertFalse((boolean)this.context.getRouteController().getRouteStatus("bar").isStarted());
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("bar"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.replaceFromWith("seda:newBar");
            }
        });
        Assertions.assertFalse((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
        Assertions.assertFalse((boolean)this.context.getRouteController().getRouteStatus("bar").isStarted());
        this.context.getRouteController().startRoute("foo");
        this.context.getRouteController().startRoute("bar");
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("bar").isStarted());
        this.getMockEndpoint("mock:newBar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AdviceWithAutoStartupTest.this.context.setAutoStartup(Boolean.valueOf(false));
                this.from("direct:start").routeId("foo").to("seda:newBar");
                this.from("seda:bar").routeId("bar").to("mock:newBar");
            }
        };
    }
}

