/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.model.InterceptSendToEndpointDefinition;

public class RecipientListInterceptSendToEndpointException
extends ContextTestSupport {
    public void testRoute() throws Exception {
        this.getMockEndpoint("mock:end").expectedMessageCount(2);
        this.getMockEndpoint("mock:intercept").expectedMessageCount(3);
        this.getMockEndpoint("ftp:foo").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("http:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"ftp:foo,http:bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)"ftp:foo");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                RecipientListInterceptSendToEndpointException.this.context.addComponent("ftp", (Component)new MockComponent());
                RecipientListInterceptSendToEndpointException.this.context.addComponent("http", (Component)new MockComponent());
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("(ftp|http):.*").to("log:intercept")).to("mock:intercept");
                this.from("direct:start").recipientList((Expression)this.header("foo")).parallelProcessing().to("mock:end");
            }
        };
    }
}

