/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParentChildInterceptStrategyTest
extends ContextTestSupport {
    protected static final List<String> LIST = new ArrayList<String>();

    @Test
    public void testParentChild() throws Exception {
        this.getMockEndpoint("mock:done").expectedMessageCount(1);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.getMockEndpoint("mock:d").expectedMessageCount(0);
        this.getMockEndpoint("mock:e").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)7, (int)LIST.size());
        Assertions.assertEquals((Object)"Parent route -> target task-a", (Object)LIST.get(0));
        Assertions.assertEquals((Object)"Parent choice -> target task-b", (Object)LIST.get(1));
        Assertions.assertEquals((Object)"Parent choice -> target task-c", (Object)LIST.get(2));
        Assertions.assertEquals((Object)"Parent choice -> target task-d", (Object)LIST.get(3));
        Assertions.assertEquals((Object)"Parent choice -> target task-e", (Object)LIST.get(4));
        Assertions.assertEquals((Object)"Parent route -> target choice", (Object)LIST.get(5));
        Assertions.assertEquals((Object)"Parent route -> target mock:done", (Object)LIST.get(6));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ParentChildInterceptStrategyTest.this.context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)new MyParentChildInterceptStrategy());
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("route").to("mock:a")).id("task-a")).choice().id("choice")).when((Predicate)this.simple("${body} contains 'Camel'")).id("when")).to("mock:b")).id("task-b")).to("mock:c")).id("task-c")).when((Predicate)this.simple("${body} contains 'Donkey'")).id("when2")).to("mock:d")).id("task-d")).otherwise().id("otherwise")).to("mock:e")).id("task-e")).end().to("mock:done");
            }
        };
    }

    public static final class MyParentChildInterceptStrategy
    implements InterceptStrategy {
        public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode node, Processor target, Processor nextTarget) {
            ProcessorDefinition definition = (ProcessorDefinition)node;
            String targetId = definition.hasCustomIdAssigned() ? definition.getId() : definition.getLabel();
            ProcessorDefinition parent = definition.getParent();
            String parentId = "";
            if (parent != null) {
                parentId = parent.hasCustomIdAssigned() ? parent.getId() : parent.getLabel();
            }
            LIST.add("Parent " + parentId + " -> target " + targetId);
            return target;
        }
    }
}

