/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptDefinition;
import org.junit.jupiter.api.Test;

public class InterceptSimpleRouteWhenStopTest
extends ContextTestSupport {
    @Test
    public void testInterceptStop() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:intercepted").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptNoStop() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:intercepted").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hi");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((InterceptDefinition)this.intercept().onWhen(this.body().contains((Object)"Hello")).to("mock:intercepted")).stop();
                this.from("direct:start").to(new String[]{"mock:foo", "mock:bar", "mock:result"});
            }
        };
    }
}

