/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RecipientListDefinition;
import org.junit.jupiter.api.Test;

public class InterceptSendToRecipientListTest
extends ContextTestSupport {
    @Test
    public void testInterceptSendToRecipientList() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.getMockEndpoint("mock:intercepted").expectedBodiesReceived(new Object[]{"Hello Bar"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Bar", "whereTo", (Object)"seda:beer");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Home", "whereTo", (Object)"seda:home");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("seda:b*").skipSendToOriginalEndpoint().to("mock:intercepted");
                ((RecipientListDefinition)this.from("direct:start").recipientList().header("whereTo")).to("mock:result");
            }
        };
    }
}

