/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InterceptSendToIssueTest
extends ContextTestSupport {
    @Test
    public void testInterceptSendTo() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("CamelInterceptedEndpoint", (Object)"direct://foo");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Exchange exchange = (Exchange)mock.getReceivedExchanges().get(0);
        Assertions.assertEquals((Object)"direct://start", (Object)exchange.getFromEndpoint().getEndpointUri());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("direct:foo").to("mock:foo");
                ((RouteDefinition)this.from("direct:start").setHeader("CamelFileName", (Expression)this.constant("hello.txt"))).to("direct:foo");
                this.from("direct:foo").log("Dummy");
            }
        };
    }
}

