/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class InterceptSendToEndpointTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testInterceptEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                InterceptSendToEndpointTest.this.context.setTracing(Boolean.valueOf(true));
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").to("mock:detour")).transform((Expression)this.constant("Bye World"));
                ((RouteDefinition)((RouteDefinition)this.from("direct:first").to("mock:bar")).to("mock:foo")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:detour").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:first", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptEndpointWithPredicate() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").onWhen(this.body().isEqualTo((Object)"Hello World")).to("mock:detour")).transform((Expression)this.constant("Bye World"));
                ((RouteDefinition)((RouteDefinition)this.from("direct:second").to("mock:bar")).to("mock:foo")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World", "Hi"});
        this.getMockEndpoint("mock:detour").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World", "Hi"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World", "Hi"});
        this.template.sendBody("direct:second", (Object)"Hello World");
        this.template.sendBody("direct:second", (Object)"Hi");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptEndpointStop() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                InterceptSendToEndpointTest.this.context.setTracing(Boolean.valueOf(true));
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().transform((Expression)this.constant("Bye World"))).to("mock:detour");
                ((RouteDefinition)((RouteDefinition)this.from("direct:third").to("mock:bar")).to("mock:foo")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:detour").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:third", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptEndpointDirectly() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("direct:start").to("mock:detour")).transform((Expression)this.constant("Bye World"));
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptEndpointWithStop() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("direct:start").to("mock:detour")).stop();
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptEndpointOnce() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("direct:intercept1").to("mock:detour1");
                this.interceptSendToEndpoint("direct:intercept2").to("mock:detour2");
                this.from("direct:input1").to("direct:intercept1");
                this.from("direct:input2").to("direct:intercept2");
                this.from("direct:intercept1").to("log:1");
                this.from("direct:intercept2").to("log:2");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour1").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:detour2").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:input1", (Object)"Hello World");
        this.template.sendBody("direct:input2", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

