/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class InterceptSendToEndpointMultipleRoutesTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testInterceptEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new MyBaseRoute(){

            @Override
            public void configure() throws Exception {
                super.configure();
                ((RouteDefinition)this.from("direct:a").to("seda:a")).to("mock:result");
            }
        });
        this.context.addRoutes((RoutesBuilder)new MyBaseRoute(){

            @Override
            public void configure() throws Exception {
                super.configure();
                ((RouteDefinition)this.from("direct:b").to("seda:b")).to("mock:result");
            }
        });
        this.context.addRoutes((RoutesBuilder)new MyBaseRoute(){

            @Override
            public void configure() throws Exception {
                super.configure();
                ((RouteDefinition)((RouteDefinition)this.from("direct:c").to("seda:c")).to("mock:c")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.getMockEndpoint("mock:detour").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"C"});
        this.template.sendBody("direct:a", (Object)"A");
        this.template.sendBody("direct:b", (Object)"B");
        this.template.sendBody("direct:c", (Object)"C");
        this.assertMockEndpointsSatisfied();
    }

    private static abstract class MyBaseRoute
    extends RouteBuilder {
        private MyBaseRoute() {
        }

        public void configure() throws Exception {
            this.interceptSendToEndpoint("seda:*").skipSendToOriginalEndpoint().to("mock:detour");
        }
    }
}

