/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import java.io.IOException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;

public class InterceptSendToEndpointInOnException
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(IOException.class).handled(true).to("mock:io");
                this.interceptSendToEndpoint("mock:io").skipSendToOriginalEndpoint().to("mock:intercepted");
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:result");
            }
        };
    }

    public void testOk() throws Exception {
        this.getMockEndpoint("mock:io").expectedMessageCount(0);
        this.getMockEndpoint("mock:intercepted").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAnotherError() throws Exception {
        this.getMockEndpoint("mock:io").expectedMessageCount(0);
        this.getMockEndpoint("mock:intercepted").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                throw new IllegalArgumentException("Forced");
            }
        });
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            InterceptSendToEndpointInOnException.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        }
        try {
            this.template.sendBody("direct:start", (Object)"Bye World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            InterceptSendToEndpointInOnException.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testIOError() throws Exception {
        this.getMockEndpoint("mock:io").expectedMessageCount(0);
        this.getMockEndpoint("mock:intercepted").expectedMessageCount(2);
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                throw new IOException("Forced");
            }
        });
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }
}

