/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class InterceptSendToEndpointDynamicTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testSendToWildcard() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("file:*").skipSendToOriginalEndpoint().to("mock:detour");
                ((RouteDefinition)((RouteDefinition)this.from("direct:first").to("file://foo")).to("file://bar")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedMessageCount(2);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:first", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendToWildcardHeaderUri() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("file:*").skipSendToOriginalEndpoint().to("mock:detour");
                ((RouteDefinition)this.from("direct:first").to("file://foo")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedMessageCount(1);
        this.getMockEndpoint("mock:detour").expectedPropertyReceived("CamelInterceptedEndpoint", (Object)"file://foo");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:first", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendToRegex() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint(InterceptSendToEndpointDynamicTest.this.fileUri("(foo|bar)")).skipSendToOriginalEndpoint().to("mock:detour");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:first").to(InterceptSendToEndpointDynamicTest.this.fileUri("foo"))).to(InterceptSendToEndpointDynamicTest.this.fileUri("bar"))).to(InterceptSendToEndpointDynamicTest.this.fileUri("cheese"))).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedMessageCount(2);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedFileExists(this.testFile("cheese/cheese.txt"));
        this.template.sendBodyAndHeader("direct:first", (Object)"Hello World", "CamelFileName", (Object)"cheese.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendToDynamicEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("file:*").to("mock:detour");
                ((RouteDefinition)this.from("direct:first").process(new Processor(){

                    public void process(Exchange exchange) {
                        InterceptSendToEndpointDynamicTest.this.template.sendBodyAndHeader(InterceptSendToEndpointDynamicTest.this.fileUri("foo"), (Object)"Hello Foo", "CamelFileName", (Object)"foo.txt");
                    }
                })).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedBodiesReceived(new Object[]{"Hello Foo"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedFileExists(this.testFile("foo/foo.txt"));
        this.template.sendBody("direct:first", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

