/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class InterceptSendToEndpointConditionalSkipTest
extends ContextTestSupport {
    @Test
    public void testInterceptSendToEndpointSkipConditionSatisfied() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:skippable").expectedMessageCount(0);
        this.getMockEndpoint("mock:detour").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"skip");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptSendToEndpointSkipConditionNotSatisfied() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:skippable").expectedMessageCount(1);
        this.getMockEndpoint("mock:detour").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptSendToEndpointSkipConditionNoEffectChoice() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(2);
        this.getMockEndpoint("mock:skippableNoEffect").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(2);
        this.getMockEndpoint("mock:noSkipWhen").expectedMessageCount(1);
        this.getMockEndpoint("mock:noSkipOW").expectedMessageCount(1);
        this.template.sendBody("direct:startNoEffect", (Object)"skipNoEffectWhen");
        this.template.sendBody("direct:startNoEffect", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("mock:skippable").skipSendToOriginalEndpoint().onWhen(this.body().isEqualTo((Object)"skip")).to("mock:detour");
                ((ChoiceDefinition)this.interceptSendToEndpoint("mock:skippableNoEffect").skipSendToOriginalEndpoint().choice().when(this.body().isEqualTo((Object)"skipNoEffectWhen")).to("mock:noSkipWhen")).otherwise().to("mock:noSkipOW");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).to("mock:skippable")).to("mock:c");
                ((RouteDefinition)((RouteDefinition)this.from("direct:startNoEffect").to("mock:a")).to("mock:skippableNoEffect")).to("mock:c");
                ((RouteDefinition)((RouteDefinition)this.from("direct:startMultipleConditions").to("mock:a")).to("mock:skippableMultipleConditions")).to("mock:c");
            }
        };
    }
}

