/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class InterceptSendToEndpointConditionalSkip2Test
extends ContextTestSupport {
    @Test
    public void testInterceptSendToEndpointNone() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:detour1").expectedMessageCount(0);
        this.getMockEndpoint("mock:detour2").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptSendToEndpoint1() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:detour1").expectedMessageCount(1);
        this.getMockEndpoint("mock:detour2").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"skip1");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptSendToEndpoint2() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:detour1").expectedMessageCount(0);
        this.getMockEndpoint("mock:detour2").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"skip2");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptSendToEndpointBoth() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:detour1").expectedMessageCount(1);
        this.getMockEndpoint("mock:detour2").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"skip1,skip2");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("mock:skip1").skipSendToOriginalEndpoint().onWhen(this.body().contains((Object)"skip1")).to("mock:detour1");
                this.interceptSendToEndpoint("mock:skip2").skipSendToOriginalEndpoint().onWhen(this.body().contains((Object)"skip2")).to("mock:detour2");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).to("mock:skip1")).to("mock:skip2")).to("mock:c");
            }
        };
    }
}

