/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class InterceptSendToEndpointAfterTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testInterceptEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                InterceptSendToEndpointAfterTest.this.context.setTracing(Boolean.valueOf(true));
                ((InterceptSendToEndpointDefinition)((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").to("mock:detour")).transform((Expression)this.constant("Bye World"))).afterUri("direct:after");
                ((RouteDefinition)((RouteDefinition)this.from("direct:first").to("mock:bar")).to("mock:foo")).to("mock:result");
                this.from("direct:after").to("mock:after");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:detour").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:first", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptEndpointDirectly() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("direct:start").to("mock:detour")).transform((Expression)this.constant("Bye World"));
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptEndpointWithStop() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("direct:start").to("mock:detour")).afterUri("mock:after");
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).transform().constant((Object)"Bye World");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptEndpointWhen() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("direct:start").onWhen((Predicate)this.simple("${body} contains 'World'")).to("mock:detour")).afterUri("mock:after");
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).transform().constant((Object)"Bye World");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World", "Hi Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hi Camel");
        this.assertMockEndpointsSatisfied();
    }
}

