/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class InterceptFromWhenNoStopTest
extends ContextTestSupport {
    @Test
    public void testInterceptorWhen() throws Exception {
        this.getMockEndpoint("mock:goofy").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.sendBody("direct:start", "Hello World!");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptorWhenGoofy() throws Exception {
        this.getMockEndpoint("mock:goofy").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.sendBody("direct:start", "Hello Goofy");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.interceptFrom().onWhen((Predicate)this.simple("${body} contains 'Goofy'")).to("mock:goofy");
                this.from("direct:start").to("mock:end");
            }
        };
    }
}

