/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class InterceptFromUriWildcardHeaderUriTest
extends ContextTestSupport {
    @Test
    public void testNoIntercept() throws Exception {
        this.getMockEndpoint("mock:intercept").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptFoo() throws Exception {
        this.getMockEndpoint("mock:intercept").expectedMessageCount(1);
        this.getMockEndpoint("mock:intercept").expectedPropertyReceived("CamelInterceptedEndpoint", (Object)"seda://foo");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInterceptBar() throws Exception {
        this.getMockEndpoint("mock:intercept").expectedMessageCount(1);
        this.getMockEndpoint("mock:intercept").expectedPropertyReceived("CamelInterceptedEndpoint", (Object)"seda://bar");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.interceptFrom("seda*").to("mock:intercept");
                this.from("direct:start").to("mock:result");
                this.from("seda:bar").to("mock:result");
                this.from("seda:foo").to("mock:result");
            }
        };
    }
}

