/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class InterceptFromSimplePredicateTest
extends ContextTestSupport {
    @Test
    public void testNoIntercept() throws Exception {
        this.getMockEndpoint("mock:intercepted").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testIntercepted() throws Exception {
        this.getMockEndpoint("mock:intercepted").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"This is a test body"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "usertype", (Object)"test");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((InterceptDefinition)this.interceptFrom().onWhen(this.header("usertype").isEqualTo((Object)"test")).process((Processor)new MyTestServiceProcessor())).to("mock:intercepted");
                ((RouteDefinition)this.from("direct:start").to("seda:bar")).to("mock:result");
            }
        };
    }

    private static class MyTestServiceProcessor
    implements Processor {
        private MyTestServiceProcessor() {
        }

        public void process(Exchange exchange) {
            exchange.getIn().setBody((Object)"This is a test body");
        }
    }
}

