/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class InterceptFromRouteTestSupport
extends ContextTestSupport {
    protected MockEndpoint a;
    protected MockEndpoint b;

    @Test
    public void testSendMatchingMessage() throws Exception {
        this.prepareMatchingTest();
        this.template.sendBodyAndHeader("direct:start", (Object)"<matched/>", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendNonMatchingMessage() throws Exception {
        this.prepareNonMatchingTest();
        this.template.sendBodyAndHeader("direct:start", (Object)"<notMatched/>", "foo", (Object)"notMatchedHeaderValue");
        this.assertMockEndpointsSatisfied();
    }

    @BeforeEach
    public void setUpMocks() throws Exception {
        super.setUp();
        this.a = this.getMockEndpoint("mock:a");
        this.b = this.getMockEndpoint("mock:b");
    }

    protected abstract void prepareMatchingTest();

    protected abstract void prepareNonMatchingTest();
}

