/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class InterceptFromEndpointInstanceTest
extends ContextTestSupport {
    @Test
    public void testIntercept() throws Exception {
        this.getMockEndpoint("mock:intercepted").expectedMessageCount(1);
        this.getMockEndpoint("mock:first").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.interceptFrom("direct*").to("mock:intercepted");
                Endpoint direct = InterceptFromEndpointInstanceTest.this.context.getEndpoint("direct:start");
                Endpoint seda = InterceptFromEndpointInstanceTest.this.context.getEndpoint("seda:bar");
                ((RouteDefinition)this.from(direct).to("mock:first")).to(seda);
                this.from(seda).to("mock:result");
            }
        };
    }
}

