/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.exceptionpolicy;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultExceptionPolicyStrategyUsingWhenTest
extends ContextTestSupport {
    private static final String ERROR_QUEUE = "mock:error";
    private static final String ERROR_USER_QUEUE = "mock:usererror";

    @Test
    public void testNoWhen() throws Exception {
        MockEndpoint mock = this.getMockEndpoint(ERROR_QUEUE);
        mock.expectedMessageCount(1);
        try {
            this.template.sendBody("direct:a", (Object)"Hello Camel");
            Assertions.fail((String)"Should have thrown an Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithWhen() throws Exception {
        MockEndpoint mock = this.getMockEndpoint(ERROR_USER_QUEUE);
        mock.expectedMessageCount(1);
        try {
            this.template.sendBodyAndHeader("direct:a", (Object)"Hello Camel", "user", (Object)"admin");
            Assertions.fail((String)"Should have thrown an Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel(DefaultExceptionPolicyStrategyUsingWhenTest.ERROR_QUEUE).redeliveryDelay(0L).maximumRedeliveries(3));
                this.onException(MyUserException.class).onWhen(this.header("user").isNotNull()).maximumRedeliveries(1).redeliveryDelay(0L).to(DefaultExceptionPolicyStrategyUsingWhenTest.ERROR_USER_QUEUE);
                this.onException(MyUserException.class).maximumRedeliveries(2).redeliveryDelay(0L).to(DefaultExceptionPolicyStrategyUsingWhenTest.ERROR_QUEUE);
                ((RouteDefinition)this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String s = (String)exchange.getIn().getBody(String.class);
                        if ("Hello Camel".equals(s)) {
                            throw new MyUserException("Forced for testing");
                        }
                        exchange.getMessage().setBody((Object)"Hello World");
                    }
                })).to("mock:result");
            }
        };
    }

    public static class MyUserException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MyUserException(String message) {
            super(message);
        }
    }
}

