/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.exceptionpolicy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.util.HashMap;
import org.apache.camel.AlreadyStoppedException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ValidationException;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultRoute;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.errorhandler.DefaultExceptionPolicyStrategy;
import org.apache.camel.processor.errorhandler.ExceptionPolicy;
import org.apache.camel.processor.errorhandler.ExceptionPolicyKey;
import org.apache.camel.reifier.errorhandler.DefaultErrorHandlerReifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultExceptionPolicyStrategyTest {
    private DefaultExceptionPolicyStrategy strategy;
    private HashMap<ExceptionPolicyKey, ExceptionPolicy> policies;
    private ExceptionPolicy type1;
    private ExceptionPolicy type2;
    private ExceptionPolicy type3;

    private ExceptionPolicy exceptionPolicy(Class<? extends Throwable> exceptionClass) {
        DefaultCamelContext cc = new DefaultCamelContext();
        DefaultRoute context = new DefaultRoute((CamelContext)cc, null, null, null, null, null);
        return new DefaultErrorHandlerReifier((Route)context, null).createExceptionPolicy(new OnExceptionDefinition(exceptionClass));
    }

    private void setupPolicies() {
        this.strategy = new DefaultExceptionPolicyStrategy();
        this.policies = new HashMap();
        this.type1 = this.exceptionPolicy(CamelExchangeException.class);
        this.type2 = this.exceptionPolicy(Exception.class);
        this.type3 = this.exceptionPolicy(IOException.class);
        this.policies.put(new ExceptionPolicyKey(null, CamelExchangeException.class, null), this.type1);
        this.policies.put(new ExceptionPolicyKey(null, Exception.class, null), this.type2);
        this.policies.put(new ExceptionPolicyKey(null, IOException.class, null), this.type3);
    }

    private void setupPoliciesNoTopLevelException() {
        this.strategy = new DefaultExceptionPolicyStrategy();
        this.policies = new HashMap();
        this.type1 = this.exceptionPolicy(CamelExchangeException.class);
        this.type3 = this.exceptionPolicy(IOException.class);
        this.policies.put(new ExceptionPolicyKey(null, CamelExchangeException.class, null), this.type1);
        this.policies.put(new ExceptionPolicyKey(null, IOException.class, null), this.type3);
    }

    private void setupPoliciesCausedBy() {
        this.strategy = new DefaultExceptionPolicyStrategy();
        this.policies = new HashMap();
        this.type1 = this.exceptionPolicy(FileNotFoundException.class);
        this.type2 = this.exceptionPolicy(ConnectException.class);
        this.type3 = this.exceptionPolicy(IOException.class);
        this.policies.put(new ExceptionPolicyKey(null, FileNotFoundException.class, null), this.type1);
        this.policies.put(new ExceptionPolicyKey(null, IOException.class, null), this.type2);
        this.policies.put(new ExceptionPolicyKey(null, ConnectException.class, null), this.type3);
    }

    private ExceptionPolicy findPolicy(Exception exception) {
        ExceptionPolicyKey key = this.strategy.getExceptionPolicy(this.policies.keySet(), null, (Throwable)exception);
        return this.policies.get(key);
    }

    @Test
    public void testDirectMatch1() {
        this.setupPolicies();
        ExceptionPolicy result = this.findPolicy((Exception)new CamelExchangeException("", null));
        Assertions.assertEquals((Object)this.type1, (Object)result);
    }

    @Test
    public void testDirectMatch2() {
        this.setupPolicies();
        ExceptionPolicy result = this.findPolicy(new Exception(""));
        Assertions.assertEquals((Object)this.type2, (Object)result);
    }

    @Test
    public void testDirectMatch3() {
        this.setupPolicies();
        ExceptionPolicy result = this.findPolicy(new IOException(""));
        Assertions.assertEquals((Object)this.type3, (Object)result);
    }

    @Test
    public void testClosetMatch3() {
        this.setupPolicies();
        ExceptionPolicy result = this.findPolicy(new ConnectException(""));
        Assertions.assertEquals((Object)this.type3, (Object)result);
        result = this.findPolicy(new SocketException(""));
        Assertions.assertEquals((Object)this.type3, (Object)result);
        result = this.findPolicy(new FileNotFoundException());
        Assertions.assertEquals((Object)this.type3, (Object)result);
    }

    @Test
    public void testClosetMatch2() {
        this.setupPolicies();
        ExceptionPolicy result = this.findPolicy(new ClassCastException(""));
        Assertions.assertEquals((Object)this.type2, (Object)result);
        result = this.findPolicy(new NumberFormatException(""));
        Assertions.assertEquals((Object)this.type2, (Object)result);
        result = this.findPolicy(new NullPointerException());
        Assertions.assertEquals((Object)this.type2, (Object)result);
    }

    @Test
    public void testClosetMatch1() {
        this.setupPolicies();
        ExceptionPolicy result = this.findPolicy((Exception)((Object)new ValidationException(null, "")));
        Assertions.assertEquals((Object)this.type1, (Object)result);
        result = this.findPolicy((Exception)new ExchangeTimedOutException(null, 0L));
        Assertions.assertEquals((Object)this.type1, (Object)result);
    }

    @Test
    public void testNoMatch1ThenMatchingJustException() {
        this.setupPolicies();
        ExceptionPolicy result = this.findPolicy((Exception)new AlreadyStoppedException());
        Assertions.assertEquals((Object)this.type2, (Object)result);
    }

    @Test
    public void testNoMatch1ThenNull() {
        this.setupPoliciesNoTopLevelException();
        ExceptionPolicy result = this.findPolicy((Exception)new AlreadyStoppedException());
        Assertions.assertNull((Object)result, (String)"Should not find an exception policy to use");
    }

    @Test
    public void testCausedBy() {
        this.setupPoliciesCausedBy();
        IOException ioe = new IOException("Damm", new FileNotFoundException("Somefile not found"));
        ExceptionPolicy result = this.findPolicy(ioe);
        Assertions.assertEquals((Object)this.type1, (Object)result);
    }

    @Test
    public void testCausedByWrapped() {
        this.setupPoliciesCausedBy();
        IOException ioe = new IOException("Damm", new FileNotFoundException("Somefile not found"));
        ExceptionPolicy result = this.findPolicy((Exception)((Object)new RuntimeCamelException((Throwable)ioe)));
        Assertions.assertEquals((Object)this.type1, (Object)result);
    }

    @Test
    public void testCausedByNotConnected() {
        this.setupPoliciesCausedBy();
        IOException ioe = new IOException("Damm", new ConnectException("Not connected"));
        ExceptionPolicy result = this.findPolicy(ioe);
        Assertions.assertEquals((Object)this.type3, (Object)result);
    }

    @Test
    public void testCausedByOtherIO() {
        this.setupPoliciesCausedBy();
        IOException ioe = new IOException("Damm", new MalformedURLException("Bad url"));
        ExceptionPolicy result = this.findPolicy(ioe);
        Assertions.assertEquals((Object)this.type2, (Object)result);
    }
}

