/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.exceptionpolicy;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.errorhandler.DefaultExceptionPolicyStrategy;
import org.apache.camel.processor.errorhandler.ExceptionPolicyStrategy;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomExceptionPolicyStrategyTest
extends ContextTestSupport {
    private static final String ERROR_QUEUE = "mock:error";
    private static final String ERROR_USER_QUEUE = "mock:usererror";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("reverse-strategy", ExceptionPolicyStrategy.class, (Object)new DefaultExceptionPolicyStrategy(){

            public Iterable<Throwable> createExceptionIterable(Throwable exception) {
                ArrayList<Throwable> answer = new ArrayList<Throwable>();
                for (Throwable throwable : super.createExceptionIterable(exception)) {
                    answer.add(0, throwable);
                }
                return answer;
            }
        });
        return answer;
    }

    @Test
    public void testReverseBehavior() throws Exception {
        MockEndpoint mock = this.getMockEndpoint(ERROR_USER_QUEUE);
        mock.expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:a", (Object)"Hello Camel");
            Assertions.fail((String)"Should have thrown an Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(IllegalStateException.class).maximumRedeliveries(1).redeliveryDelay(0L).to(CustomExceptionPolicyStrategyTest.ERROR_USER_QUEUE);
                this.onException(Exception.class).maximumRedeliveries(1).redeliveryDelay(0L).to(CustomExceptionPolicyStrategyTest.ERROR_QUEUE);
                ((RouteDefinition)this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) {
                        String s = (String)exchange.getIn().getBody(String.class);
                        if ("Hello Camel".equals(s)) {
                            throw new MyUserException("Forced for testing", new IOException("Uh oh!"));
                        }
                        exchange.getMessage().setBody((Object)"Hello World");
                    }
                })).to("mock:result");
            }
        };
    }

    public static class MyUserException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        public MyUserException(String message) {
            super(message);
        }

        protected MyUserException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

